#include "stdafx.h"
#include <list>
using std::list;
#include <map>
using std::pair;

class HCEllipses {
private:
    typedef pair<CPoint,CPoint> PointPair;
	list<PointPair> pointPairs;
    PointPair currentPointPair;
    void drawEllipse(CDC *pDC, PointPair p, COLORREF color = 0, 
                        int style = PS_SOLID) {
        CPen pen(style,1,color);
	CPen *oldPen = pDC->SelectObject(&pen);
	pDC->Ellipse(p.first.x,  p.first.y, p.second.x, p.second.y);
	pDC->SelectObject(oldPen);
    }
    void eraseEllipse(CDC *pDC, PointPair p) {
        drawEllipse(pDC,p,RGB(255,255,255));
    }
    bool dragging;
public:
    HCEllipses(): dragging(false){}
    void onDraw(CDC *pDC) {
        for (list<PointPair>::iterator i = pointPairs.begin();
                i != pointPairs.end(); ++i)
            drawEllipse(pDC,*i);
    }
    void onLButtonDown(CPoint p) {
        dragging = true;
        currentPointPair.first = currentPointPair.second = p;
    }
    void onMouseMove(CPoint p, CWnd *pWnd) {
        if (dragging) {
            CClientDC dc(pWnd);
            eraseEllipse(&dc, currentPointPair);
            currentPointPair.second = p;
            drawEllipse(&dc, currentPointPair, 0, PS_DASH);
        }
    }        
    void onLButtonUp(CPoint p, CWnd *pWnd) {
        if (dragging) {
            currentPointPair.second = p;
            pointPairs.push_back(currentPointPair);
            pWnd->Invalidate();
            dragging = false;
        }
    }
};
